;***************************************************************************
;            This file is Freescale Confidential Proprietary
;            (C) Copyright Freescale 2006 ALL RIGHTS RESERVED
;
;  FILE NAME: __start.s                     
;                                           
;  DESCRIPTION:                             
;                                                                          
;  __start:  Main entry point for the MPC5500 initialization routines.     
;
;  Operations:                                   
;  	1. init sram
;	2. enable cache
;	3. set PLL to desired freq
;	4. put stack in cache
;	5. set FLASH_BIUCR (execute out of cache or SRAM when changing)
; 	6. copy intialized variables to RAM.
;	7. set BUCSR (BTB = Branch Target Buffer)
;       8. branch to main().
; 
;***************************************************************************/

;**************************************
; Must set this define correctly for the linker file you use
;   _ROM_IMAGE = 1 for ghs_romcfg.ld
;   _ROM_IMAGE = 0 for ghs_ramcfg.ld
.equ _ROM_IMAGE, 1
	
  	.globl __start_p0

;**************************************
; externs                                                	
    .extern main             	; located in Scheduler.c
    .extern init_L2RAM	     	; located in init_sram.s
    ;.extern stack_config     	; located in init_stack.s
    ;.extern cfg_ROMCOPY	        ; located in rom_copy.s
    ;.extern cfg_MMU             ; located in cfg_MMU.s
	;.extern cfg_FLASH           ; located in cfg_flash.s
	.extern long EXCEPTION_HANDLERS;
	.extern long __SDA_BASE;
	.extern long __SDA2_BASE;
	.extern long __SP_INIT;
	.extern long __ROM_COPY_SIZE;
	.extern long __SP_INIT;
;**************************************
; .reset config half word section, required for execution from Flash
    	.section .resetvector
    	.long 0x005a0000
    	.long __start_p0

;**************************************
; .init section
  .section .text    		; The "ax" generates symbols for debug

;********************************************************************************************
__start_p0:

;************************************
; Call the individual assembly modules:
.if _ROM_IMAGE
	bl init_L2RAM	     		; located in init_sram.s
.endif
  
; Initialize IVPR register to address of Interrupt Vector Table 
     lis r5, EXCEPTION_HANDLERS@h
     ori r5, r5,EXCEPTION_HANDLERS@l
     mtIVPR r5
;**************************************
; Turn on the branch target buffer (this improves performance). Branch Prediction bit = ON
    mfspr r6, BUCSR			; SPR ?
    ori r6, r6, 0x1			; or in BPEN bit (bit 31)
    mtspr BUCSR, r6

;**************************************
; initialize SDA and SDA2 pointers per PPC EABI
	lis	r13, __SDA_BASE@h	; SDA base register
	ori	r13, r13, __SDA_BASE@l
	lis	r2, __SDA2_BASE@h
	ori 	r2, r2, __SDA2_BASE@l


;**************************************
; Branch to main program
	lis  r6, main@ha
    	addi r6, r6, main@l
    	mtlr r6
    	blrl

; End of __start

